<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 697px;">
        <div class="container-full">
            <!-- Content Header (Page header) -->
            <div class="content-header d-none d-md-block d-lg-block">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h4 class="page-title">Master Dashboard</h4>
                        <div class="d-inline-block align-items-center">
                            <nav>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="#"><i class="fa fa-home"
                                                aria-hidden="true"></i></a></li>
                                    <li class="breadcrumb-item" aria-current="page"><?= $title ?></li>
                                </ol>
                            </nav>
                        </div>
                    </div>

                </div>
            </div> <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-sm-12 col-md-12 col-lg-6 offset-lg-2">
                        <?php echo $__env->make('partials.validation_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <div class="card">
                            <div class="card-body" style="padding: 50px;">

                                <div class="text-center">
                                    <h1 class="h4 text-gray-900 mb-4">Register Admin Account</h1>
                                </div>
                                <form action="<?php echo e(route('master.admin.store')); ?>" class="user" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label for="name">Name</label>
                                        <input type="name" class="form-control" id="name" name="name"
                                            placeholder="Enter name">
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-sm-6 mb-3 mb-sm-0">
                                            <label for="email">Email</label>
                                            <input type="email" class="form-control" id="email" name="email"
                                                placeholder="Email Address">
                                        </div>
                                        <div class="col-sm-6 mb-3 mb-sm-0">
                                            <label for="registration_token">Registration Token</label>
                                            <input type="text" class="form-control" id="registration_token"
                                                name="registration_token"
                                                placeholder="Enter a registration code for this admin">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="password">Password</label>
                                        <input type="text" class="form-control" id="password" name="password"
                                            placeholder="Password">
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-sm-6 mb-3 mb-sm-0">
                                            <label for="dial_code">Dial code</label>
                                            <select name="dial_code" id=""
                                                class="form-control bg-light border-1 small">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = config('setting.dial_code'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $dialCode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="+<?php echo e($key); ?>"
                                                        <?php echo e(old('dial_code') == '+' . $key ? 'selected' : ''); ?>>
                                                        <?php echo e($dialCode); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-sm-6">
                                            <label>Phone</label>
                                            <input type="number" name="phone" value="<?php echo e(old('phone')); ?>"
                                                class="form-control bg-light border-0 small" placeholder="Phone">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>Address</label>
                                        <input type="text" name="address" value="<?php echo e(old('address')); ?>"
                                            class="form-control bg-light border-0 small" placeholder="Address">
                                    </div>
                                    <input type="submit" class="btn btn-success btn-user btn-block"
                                        value="Register Account" id="admin_register">
                                </form>
                            </div>

                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.master.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\online-banking-v4.1\resources\views\dashboard\master\admin\create.blade.php ENDPATH**/ ?>