<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="container-full">
            <!-- Content Header (Page header) -->
            <div class="content-header d-none d-md-block d-lg-block">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h4 class="page-title"><?php echo e($admin->email); ?></h4>
                        <div class="d-inline-block align-items-center">
                            <nav>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="/"><i class="fa fa-home"
                                                aria-hidden="true"></i></a></li>
                                    <li class="breadcrumb-item" aria-current="page"><?php echo e($title); ?></li>
                                </ol>
                            </nav>
                        </div>
                    </div>

                </div>
            </div> <!-- Main content -->
            <section class="content">
                <!-- Basic Card Example -->
                <div class="row">
                    <div class="col-sm-12 col-md-8">
                        <?php echo $__env->make('partials.validation_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <div class="card shadow mb-4 border-left-danger ">
                            <div class="card-header d-flex justify-content-between">
                                <i class="fa fa-user-circle fa-3x" aria-hidden="true"></i>
                                <?php echo $__env->make('dashboard.admin.users.partials.account_option_and_status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.users.account.state.setting.update', $user->uuid)); ?>"
                                    class="user" method="post">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-group">
                                        <label>Set state</label>
                                        <select class="form-control" required name="account_state">
                                            <option value="">Select</option>
                                            <?php $__currentLoopData = $accountStates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accountState): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($accountState->value); ?>"
                                                    <?php echo e($user->account_state == $accountState->value ? 'selected' : ''); ?>>
                                                    <?php echo e($accountState->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <small class="text-muted d-block">Frozen account users cannot make
                                            transfers</small>
                                        <small class="text-muted d-block">Disabled users cannot login</small>
                                        <small class="text-muted d-block">KYC users will be unable to make
                                            withdrawals</small>
                                    </div>
                                    <div class="form-group">
                                        <label>Set message</label>
                                        <textarea name="account_state_reason" class="form-control"><?php echo e($user->account_state_reason); ?></textarea>
                                        <small class="text-muted">This message will appear when user
                                            login</small>
                                    </div>
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\online-banking-v4.1\resources\views/dashboard/admin/users/account_state_setting/index.blade.php ENDPATH**/ ?>