<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="container-full">
            <!-- Content Header (Page header) -->
            <div class="content-header d-none d-md-block d-lg-block">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h4 class="page-title"><?php echo e($admin->email); ?></h4>
                        <div class="d-inline-block align-items-center">
                            <nav>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="/"><i class="fa fa-home"
                                                aria-hidden="true"></i></a></li>
                                    <li class="breadcrumb-item" aria-current="page"><?php echo e($title); ?></li>
                                </ol>
                            </nav>
                        </div>
                    </div>

                </div>
            </div> <!-- Main content -->
            <section class="content">
                <!-- Basic Card Example -->
                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="card shadow mb-4 border-bottom-success">
                            <div class="card-header py-3 d-flex justify-content-between">
                                <i class="fa fa-user-circle fa-3x" aria-hidden="true"></i>
                                <?php echo $__env->make('dashboard.admin.users.partials.account_option_and_status', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="row">
                                <div class="col-sm-12 col-md-7">
                                    <div class="card-body">
                                        <dl class="row">
                                            <h5 class="col-sm-12 text-primary">Withdrawal Details</h5>
                                            <dt class="col-sm-4">Withdrawal Method:</dt>
                                            <dd class="col-sm-8"><?php echo e($transfer->type); ?></dd>
                                            <dt class="col-sm-4">Withdrawal Amount:</dt>
                                            <dd class="col-sm-8">
                                                <strong><?php echo e(currency($user->currency) . formatAmount($transfer->amount)); ?></strong>
                                                <?php echo e($transfer->currency); ?>

                                            </dd>
                                            <dt class="col-sm-4"> Completed Process:</dt>
                                            <dd class="col-sm-8">
                                                <?php if($transfer->status == 0): ?>
                                                    <i class="fa fa-times-circle text-danger" aria-hidden="true"></i>
                                                <?php elseif($transfer->status == 2): ?>
                                                    <i class="fa fa-times-circle text-danger" aria-hidden="true"></i>
                                                <?php else: ?>
                                                    <i class="fa fa-check-circle text-success" aria-hidden="true"></i>
                                                <?php endif; ?>
                                            </dd>
                                            <dt class="col-sm-4">Withdrawal Method:</dt>
                                            <dd class="col-sm-8"><?php echo e($transfer->type); ?></dd>
                                            <dt class="col-sm-4">Date:</dt>
                                            <dd class="col-sm-8"><?php echo e(date('dS M,Y', strtotime($transfer->created_at))); ?>

                                            </dd>

                                            <h5 class="col-sm-12 text-primary">Beneficiary Details</h5>
                                            <?php if($transfer->type == 'Electronic Transfer'): ?>
                                                <dt class="col-sm-4"><?php echo e($transfer->withdrawal_method); ?> Details:</dt>
                                                <dd class="col-sm-4"><?php echo e($transfer->beneficiary); ?></dd>
                                            <?php else: ?>
                                                <dt class="col-sm-4">Bank Name:</dt>
                                                <dd class="col-sm-8"><?php echo e($transfer->bank_name); ?></dd>
                                                <dt class="col-sm-4">Account Name:</dt>
                                                <dd class="col-sm-8"><?php echo e($transfer->account_name); ?></dd>
                                                <dt class="col-sm-4">Account Number:</dt>
                                                <dd class="col-sm-8"><?php echo e($transfer->account_number); ?></dd>
                                                <dt class="col-sm-4">Routing Number:</dt>
                                                <dd class="col-sm-8"><?php echo e($transfer->routing_number); ?></dd>
                                            <?php endif; ?>

                                            <h5 class="col-sm-12 text-primary">Verification codes</h5>
                                            <?php $__empty_1 = true; $__currentLoopData = $transferCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <dt class="col-sm-4"><?php echo e($code->name); ?></dt>
                                                <dd class="col-sm-8"><?php echo e($code->code); ?></dd>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <dd class="col-12">No verification codes</dd>
                                            <?php endif; ?>
                                        </dl>
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-5">
                                    <?php echo $__env->make('dashboard.admin.users.partials.personal_account_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- /.content -->
        <?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\online-banking-v4.1\resources\views\dashboard\admin\users\withdrawal\show.blade.php ENDPATH**/ ?>