<!DOCTYPE html>
<html lang="en">

    <meta http-equiv="content-type" content="text/html;charset=UTF-8" />

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?php echo e($title); ?> &mdash; <?php echo e(config('app.name')); ?></title>
        <!-- Description -->
        <meta
            content="Online Banking, Internet Banking, Secure Banking, Financial Management, Fund Transfer, Bill Payments, 24/7 Access, Digital Banking, Personalized Banking"
            name="keywords">
        <meta
            content="Experience secure and convenient online banking with our platform. Manage your finances, transfer funds, and enjoy 24/7 access to your accounts. Explore our advanced features for a seamless and personalized banking experience."
            name="description">
        <meta property="og:title" content="<?php echo e(config('app.name')); ?> - Secure Online Banking" />
        <meta property="og:type" content="website" />
        <meta property="og:url" content="<?php echo e(url()->current()); ?>" />
        <meta property="og:image"
            content="<?php echo e(asset('dashboard/resources/images/istockphoto-1304484797-612x612.jpg')); ?>" />

        <!-- Favicon -->
        <link rel="shortcut icon" href="/dashboard/resources/images/favicon.png">

        <!-- Vendors Style-->
        <link rel="stylesheet" href="/dashboard/resources/css/vendors_css.css">
        <!-- Style-->
        <link rel="stylesheet" href="/dashboard/resources/css/style.css">
        <link rel="stylesheet" href="/dashboard/resources/css/skin_color.css">
    </head>

    <body class="hold-transition theme-primary bg-img  text-primary">
        <div class="container">
            <div class="row">
                <section
                    style="height: 200px; background-image: url(<?php echo e(asset('assets/bnkasset/images/slider-10-1920x1280.jpg')); ?>); margin-top:-100;">
                </section>

                <div class="col-sm-12 col-md-6 offset-md-3 mt-100">
                    <div class="text-center">
                        <a href="/"><img width="300" src="/dashboard/resources/images/logo.png" alt=""
                                srcset=""></a>
                        <h1 class="h4">Send us a message</h1>
                        <p class="mb-4">Having issues? and need assistance?, Send us a message, and we will get in
                            touch with you
                        </p>
                    </div>

                    <?php echo $__env->make('partials.validation_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->make('partials.theme_alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <form action="<?php echo e(route('contact.store')); ?>" method="post" class="user">
                        <?php echo csrf_field(); ?>
                        <div class="form-group col-12">
                            <input type="text" name="name" placeholder="Your Name" required
                                value="<?php echo e(old('name')); ?>" class="form-control">
                        </div>
                        <div class="form-group col-12">
                            <input type="email" name="email" placeholder="Your email" required
                                value="<?php echo e(old('email')); ?>" class="form-control">
                        </div>
                        <div class="form-group col-12">
                            <input type="text" name="phone" required placeholder="Phone"
                                value="<?php echo e(old('phone')); ?>" class="form-control">
                        </div>
                        <div class="form-group col-12">
                            <input type="text" name="subject" required placeholder="Subject"
                                value="<?php echo e(old('subject')); ?>" class="form-control">
                        </div>
                        <div class="form-group col-lg-12 col-md-12 col-sm-12">
                            <textarea name="message" placeholder="Type message" class="form-control"><?php echo e(old('message')); ?></textarea>
                        </div>
                        <div class="form-group col-lg-12 col-md-12 col-sm-12 text-center">
                            <button class="btn btn-primary" type="submit" name="submit-form">Send Message</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
        <!-- Vendor JS -->
        <script src="/dashboard/resources/js/vendors.min.js"></script>
        <script src="/dashboard/resources/js/pages/chat-popup.js"></script>
        <script src="/dashboard/resources/assets/icons/feather-icons/feather.min.php"></script>

        <script src="/dashboard/resources/js/themes/animated.js"></script>
        <script src="/dashboard/resources/assets/vendor_components/Web-Ticker-master/jquery.webticker.min.js"></script>
        <script src="/dashboard/resources/assets/vendor_components/moment/min/moment.min.php"></script>
        <script src="/dashboard/resources/assets/vendor_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.php">
        </script>

        <!-- Specie Admin Admin App -->
        <script src="/dashboard/resources/js/demo.js"></script>
        <script src="/dashboard/resources/js/template.js"></script>
        <script src="/dashboard/resources/js/pages/dashboard.js"></script>

        <script>
            var myModal = new bootstrap.Modal(document.getElementById('modal-center'), {
                keyboard: false
            })
            myModal.show();
        </script>
        <?php echo $__env->make('partials.live_chat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v4.1\resources\views/pages/contact.blade.php ENDPATH**/ ?>