<?php $__env->startSection('content'); ?>
    <div class="content-wrapper" style="min-height: 697px;">
        <div class="container-full">
            <!-- Content Header (Page header) -->
            <div class="content-header d-none d-md-block d-lg-block">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h4 class="page-title">My account</h4>
                        <div class="d-inline-block align-items-center">
                            <nav>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="#"><i class="fa fa-home"
                                                aria-hidden="true"></i></a></li>
                                    <li class="breadcrumb-item" aria-current="page"><?= $title ?></li>
                                </ol>
                            </nav>
                        </div>
                    </div>

                </div>
            </div> <!-- Main content -->
            <section class="content">
                <!-- Basic Card Example -->
                <div class="row">
                    <div class="col-sm-12 col-md-12">
                        <div class="shadow mb-4 border-bottom-success">
                            <div class="card-header py-3 d-flex justify-content-between">
                                <?php echo $__env->make('dashboard.user.partials.balance_and_currency', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <?php echo $__env->make('dashboard.user.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="row">
                                <div class="col-sm-12 col-md-7">
                                    <div class="card-header mb-3">
                                        <h4>User transactions</h4>
                                        <p>Transaction history</p>
                                    </div>
                                    <div class="list-group">
                                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <a href="<?php echo e(route('user.transaction.show',$transaction->uuid)); ?>"
                                                class="list-group-item list-group-item-action list-group-item-default">
                                                <span
                                                    class="badge <?php echo e($transaction->type == 'CREDIT' ? 'badge-success' : 'badge-danger'); ?> float-right"><?php echo e($transaction->type); ?></span>
                                                <h5 class="m-0 p-0"><span
                                                        class="<?php echo e($transaction->type == 'CREDIT' ? 'text-success' : 'text-danger'); ?>"><?php echo e(currency($user->currency) . formatAmount($transaction->amount)); ?></span>
                                                    <small><?php echo e(currency($user->currency, 'name')); ?></small>
                                                </h5>
                                                <p class="m-0 p-0"><?php echo e($transaction->description); ?></p>
                                                <p class="text-primary">Balance:
                                                    <?php echo e(currency($user->currency) . formatAmount($transaction->current_balance)); ?>

                                                </p>
                                                <small class="float-right">
                                                    Date: <?php echo e(date('dS M, Y', strtotime($transaction->date))); ?>

                                                </small>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <div class="card-body scroll-card-body">
                                                <div class="alert alert-warning" role="alert">
                                                    <strong>No transactions yet</strong>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                    </div>

                                    <div class="card-footer">
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-5">
                                    <?php echo $__env->make('dashboard.user.partials.personal_account_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\online-banking-v4.1\resources\views\dashboard\user\transaction\index.blade.php ENDPATH**/ ?>